// -------------------------------------------------
// declare the terrain types here
// -------------------------------------------------
$terrainTypes[0, type]           = "superflat";
$terrainTypes[0, description]    = "Super flat terrain";
$terrainTypes[0, visDistance]    = 3000;
$terrainTypes[0, hazeDistance]   = 2000;
$terrainTypes[0, screenSize]     = 90;

$terrainTypes[1, type]           = "flat";
$terrainTypes[1, description]    = "Flat terrain";
$terrainTypes[1, visDistance]    = 3000;
$terrainTypes[1, hazeDistance]   = 2000;
$terrainTypes[1, screenSize]     = 90;

$terrainTypes[2, type]           = "rolplains";
$terrainTypes[2, description]    = "Rolling plains";
$terrainTypes[2, visDistance]    = 3000;
$terrainTypes[2, hazeDistance]   = 2000;
$terrainTypes[2, screenSize]     = 70;

$terrainTypes[3, type]           = "rolhills";
$terrainTypes[3, description]    = "Rolling hills";
$terrainTypes[3, visDistance]    = 3000;
$terrainTypes[3, hazeDistance]   = 1500;
$terrainTypes[3, screenSize]     = 70;

$terrainTypes[4, type]           = "modhills";
$terrainTypes[4, description]    = "Moderately hilly";
$terrainTypes[4, visDistance]    = 3000;
$terrainTypes[4, hazeDistance]   = 1500;
$terrainTypes[4, screenSize]     = 70;

$terrainTypes[5, type]           = "bighills";
$terrainTypes[5, description]    = "Large hills";
$terrainTypes[5, visDistance]    = 3000;
$terrainTypes[5, hazeDistance]   = 1500;
$terrainTypes[5, screenSize]     = 55;

$terrainTypes[6, type]           = "rughills";
$terrainTypes[6, description]    = "Rugged hills";
$terrainTypes[6, visDistance]    = 3000;
$terrainTypes[6, hazeDistance]   = 1500;
$terrainTypes[6, screenSize]     = 40;

$terrainTypes[7, type]           = "imported";
$terrainTypes[7, description]    = "Imported terrain";
$terrainTypes[7, visDistance]    = 3000;
$terrainTypes[7, hazeDistance]   = 1500;
$terrainTypes[7, screenSize]     = 70;

// -------------------------------------------------
// super flat terrain
// -------------------------------------------------
function Terrain::superflat::create(%seed)
{
   if(%seed == "")
      %seed = $ME::terrainSeed;

   LS::addCommand("seed " @ %seed);
   LS::addCommand("terrain 256 1");
   LS::addCommand("normalize 0 0");
}

// -------------------------------------------------
// pretty flat terrain
// -------------------------------------------------
function Terrain::flat::create(%seed)
{
   if(%seed == "")
      %seed = $ME::terrainSeed;

   LS::addCommand("seed " @ %seed);
   LS::addCommand("terrain 256 .9");
   LS::addCommand("normalize 0 100");
}

// -------------------------------------------------
// rolling plains
// -------------------------------------------------
function Terrain::rolplains::create(%seed)
{
   if(%seed == "")
      %seed = $ME::terrainSeed;

   LS::addCommand("seed " @ %seed      );      
   LS::addCommand("terrain 256 .8"      );
   LS::addCommand("normalize 0 600"      );
   LS::addCommand("floor   200 400 0"   );
   LS::addCommand("clamp   5   20"         );
   LS::addCommand("clamp   4   10"         );
   LS::addCommand("clamp   3   5"         );
   LS::addCommand("clamp   2   2"         );
   LS::addCommand("clamp   1   0"         );
   LS::addCommand("smooth   0.005   5"      );
   LS::addCommand("normalize   0   200"   );
}

// -------------------------------------------------
// rolling hills
// -------------------------------------------------
function Terrain::rolhills::create(%seed)
{
   if(%seed == "")
      %seed = $ME::terrainSeed;
 
   LS::addCommand("seed " @ %seed      );      
   LS::addCommand("terrain 256 .8"      );
   LS::addCommand("normalize 0 600"      );
   LS::addCommand("clamp   5   20"         );
   LS::addCommand("clamp   4   10"         );
   LS::addCommand("clamp   3   5"         );
   LS::addCommand("clamp   2   2"         );
   LS::addCommand("clamp   1   0"         );
   LS::addCommand("smooth   0.005   5"      );
   LS::addCommand("normalize   0   600"   );
}

// -------------------------------------------------
// moderately hilly
// -------------------------------------------------
function Terrain::modhills::create(%seed)
{
   if(%seed == "")
      %seed = $ME::terrainSeed;

   LS::addCommand("seed " @ %seed      );      
   LS::addCommand("terrain 256 .8"      );
   LS::addCommand("normalize 0 600"      );
   LS::addCommand("floor   250 550 0"   );
   LS::addCommand("clamp   5   20"         );
   LS::addCommand("clamp   4   10"         );
   LS::addCommand("clamp   3   5"         );
   LS::addCommand("clamp   2   2"         );
   LS::addCommand("clamp   1   0"         );
   LS::addCommand("smooth   0.005   5"      );
   LS::addCommand("normalize   0   600"   );
}

// -------------------------------------------------
// really hilly
// -------------------------------------------------
function Terrain::bighills::create(%seed)
{
   if(%seed == "")
      %seed = $ME::terrainSeed;

   LS::addCommand("seed " @ %seed      );      
   LS::addCommand("terrain 256 .6"      );
   LS::addCommand("normalize 0 600"      );
   LS::addCommand("clamp   5   20"         );
   LS::addCommand("clamp   4   10"         );
   LS::addCommand("clamp   3   5"         );
   LS::addCommand("clamp   2   2"         );
   LS::addCommand("clamp   1   0"         );
   LS::addCommand("smooth   0.005   5"      );
   LS::addCommand("normalize   0   800"   );
}

// -------------------------------------------------
// rugged hills
// -------------------------------------------------
function Terrain::rughills::create(%seed)
{
   if(%seed == "")
      %seed = $ME::terrainSeed;

   LS::addCommand("seed " @ %seed      );      
   LS::addCommand("terrain 256 .6"      );
   LS::addCommand("normalize 0 600"      );
   LS::addCommand("floor   200 250 0"   );
   LS::addCommand("clamp   5   20"         );
   LS::addCommand("clamp   4   10"         );
   LS::addCommand("clamp   3   5"         );
   LS::addCommand("clamp   2   2"         );
   LS::addCommand("clamp   1   0"         );
   LS::addCommand("normalize   0   800"   );
}

// -------------------------------------------------
// imported terrain
// -------------------------------------------------
function Terrain::imported::create(%seed)
{
   if(%seed == "")
      %seed = $ME::terrainSeed;

   LS::addCommand("load heightmap.bmp");		// Your heightmap.bmp should be somewhere in the Starsiege folders
   LS::addCommand("normalize 0 200");		// Edit the min and max height to match your heightmap
}
